/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.RunbookDraftsClient;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftUndoEditResultInner;
import com.azure.resourcemanager.automation.implementation.RunbookDraftImpl;
import com.azure.resourcemanager.automation.implementation.RunbookDraftUndoEditResultImpl;
import com.azure.resourcemanager.automation.models.RunbookDraft;
import com.azure.resourcemanager.automation.models.RunbookDraftUndoEditResult;
import com.azure.resourcemanager.automation.models.RunbookDrafts;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class RunbookDraftsImpl
implements RunbookDrafts {
    private static final ClientLogger LOGGER = new ClientLogger(RunbookDraftsImpl.class);
    private final RunbookDraftsClient innerClient;
    private final AutomationManager serviceManager;

    public RunbookDraftsImpl(RunbookDraftsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Flux<ByteBuffer>> getContentWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().getContentWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public Flux<ByteBuffer> getContent(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.serviceClient().getContent(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength) {
        return this.serviceClient().replaceContent(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength);
    }

    @Override
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, Flux<ByteBuffer> runbookContent, long contentLength, Context context) {
        return this.serviceClient().replaceContent(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context);
    }

    @Override
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength) {
        return this.serviceClient().replaceContent(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength);
    }

    @Override
    public BinaryData replaceContent(String resourceGroupName, String automationAccountName, String runbookName, BinaryData runbookContent, long contentLength, Context context) {
        return this.serviceClient().replaceContent(resourceGroupName, automationAccountName, runbookName, runbookContent, contentLength, context);
    }

    @Override
    public Response<RunbookDraft> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        Response<RunbookDraftInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, runbookName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RunbookDraftImpl((RunbookDraftInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RunbookDraft get(String resourceGroupName, String automationAccountName, String runbookName) {
        RunbookDraftInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, runbookName);
        if (inner != null) {
            return new RunbookDraftImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RunbookDraftUndoEditResult> undoEditWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        Response<RunbookDraftUndoEditResultInner> inner = this.serviceClient().undoEditWithResponse(resourceGroupName, automationAccountName, runbookName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RunbookDraftUndoEditResultImpl((RunbookDraftUndoEditResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public RunbookDraftUndoEditResult undoEdit(String resourceGroupName, String automationAccountName, String runbookName) {
        RunbookDraftUndoEditResultInner inner = this.serviceClient().undoEdit(resourceGroupName, automationAccountName, runbookName);
        if (inner != null) {
            return new RunbookDraftUndoEditResultImpl(inner, this.manager());
        }
        return null;
    }

    private RunbookDraftsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

