/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.RunbookCreateOrUpdateParametersInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.RunbookDraftImpl;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.Runbook;
import com.azure.resourcemanager.automation.models.RunbookDraft;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import com.azure.resourcemanager.automation.models.RunbookProvisioningState;
import com.azure.resourcemanager.automation.models.RunbookState;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import com.azure.resourcemanager.automation.models.RunbookUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RunbookImpl
implements Runbook,
Runbook.Definition,
Runbook.Update {
    private RunbookInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String runbookName;
    private RunbookCreateOrUpdateParametersInner createParameters;
    private RunbookUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public RunbookTypeEnum runbookType() {
        return this.innerModel().runbookType();
    }

    @Override
    public ContentLink publishContentLink() {
        return this.innerModel().publishContentLink();
    }

    @Override
    public RunbookState state() {
        return this.innerModel().state();
    }

    @Override
    public Boolean logVerbose() {
        return this.innerModel().logVerbose();
    }

    @Override
    public Boolean logProgress() {
        return this.innerModel().logProgress();
    }

    @Override
    public Integer logActivityTrace() {
        return this.innerModel().logActivityTrace();
    }

    @Override
    public Integer jobCount() {
        return this.innerModel().jobCount();
    }

    @Override
    public Map<String, RunbookParameter> parameters() {
        Map<String, RunbookParameter> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> outputTypes() {
        List<String> inner = this.innerModel().outputTypes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public RunbookDraft draft() {
        RunbookDraftInner inner = this.innerModel().draft();
        if (inner != null) {
            return new RunbookDraftImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RunbookProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public RunbookInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public RunbookImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Runbook create() {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Runbook create(Context context) {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, this.createParameters, context).getValue());
        return this;
    }

    RunbookImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new RunbookInner();
        this.serviceManager = serviceManager;
        this.runbookName = name;
        this.createParameters = new RunbookCreateOrUpdateParametersInner();
    }

    @Override
    public RunbookImpl update() {
        this.updateParameters = new RunbookUpdateParameters();
        return this;
    }

    @Override
    public Runbook apply() {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Runbook apply(Context context) {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, this.updateParameters, context).getValue());
        return this;
    }

    RunbookImpl(RunbookInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.runbookName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "runbooks");
    }

    @Override
    public Runbook refresh() {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().getWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Runbook refresh(Context context) {
        this.innerObject = (RunbookInner)((Object)this.serviceManager.serviceClient().getRunbooks().getWithResponse(this.resourceGroupName, this.automationAccountName, this.runbookName, context).getValue());
        return this;
    }

    @Override
    public void publish() {
        this.serviceManager.runbooks().publish(this.resourceGroupName, this.automationAccountName, this.runbookName);
    }

    @Override
    public void publish(Context context) {
        this.serviceManager.runbooks().publish(this.resourceGroupName, this.automationAccountName, this.runbookName, context);
    }

    @Override
    public RunbookImpl withRunbookType(RunbookTypeEnum runbookType) {
        this.createParameters.withRunbookType(runbookType);
        return this;
    }

    @Override
    public RunbookImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public RunbookImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public RunbookImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public RunbookImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public RunbookImpl withLogVerbose(Boolean logVerbose) {
        if (this.isInCreateMode()) {
            this.createParameters.withLogVerbose(logVerbose);
            return this;
        }
        this.updateParameters.withLogVerbose(logVerbose);
        return this;
    }

    @Override
    public RunbookImpl withLogProgress(Boolean logProgress) {
        if (this.isInCreateMode()) {
            this.createParameters.withLogProgress(logProgress);
            return this;
        }
        this.updateParameters.withLogProgress(logProgress);
        return this;
    }

    @Override
    public RunbookImpl withDraft(RunbookDraftInner draft) {
        this.createParameters.withDraft(draft);
        return this;
    }

    @Override
    public RunbookImpl withPublishContentLink(ContentLink publishContentLink) {
        this.createParameters.withPublishContentLink(publishContentLink);
        return this;
    }

    @Override
    public RunbookImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public RunbookImpl withLogActivityTrace(Integer logActivityTrace) {
        if (this.isInCreateMode()) {
            this.createParameters.withLogActivityTrace(logActivityTrace);
            return this;
        }
        this.updateParameters.withLogActivityTrace(logActivityTrace);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

