/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookPropertiesInner;
import com.azure.resourcemanager.automation.implementation.RunbookDraftImpl;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookDraft;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import com.azure.resourcemanager.automation.models.RunbookProperties;
import com.azure.resourcemanager.automation.models.RunbookProvisioningState;
import com.azure.resourcemanager.automation.models.RunbookState;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RunbookPropertiesImpl
implements RunbookProperties {
    private RunbookPropertiesInner innerObject;
    private final AutomationManager serviceManager;

    RunbookPropertiesImpl(RunbookPropertiesInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public RunbookTypeEnum runbookType() {
        return this.innerModel().runbookType();
    }

    @Override
    public ContentLink publishContentLink() {
        return this.innerModel().publishContentLink();
    }

    @Override
    public RunbookState state() {
        return this.innerModel().state();
    }

    @Override
    public Boolean logVerbose() {
        return this.innerModel().logVerbose();
    }

    @Override
    public Boolean logProgress() {
        return this.innerModel().logProgress();
    }

    @Override
    public Integer logActivityTrace() {
        return this.innerModel().logActivityTrace();
    }

    @Override
    public Integer jobCount() {
        return this.innerModel().jobCount();
    }

    @Override
    public Map<String, RunbookParameter> parameters() {
        Map<String, RunbookParameter> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> outputTypes() {
        List<String> inner = this.innerModel().outputTypes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public RunbookDraft draft() {
        RunbookDraftInner inner = this.innerModel().draft();
        if (inner != null) {
            return new RunbookDraftImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RunbookProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public RunbookPropertiesInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

