/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.RunbooksClient;
import com.azure.resourcemanager.automation.fluent.models.RunbookCreateOrUpdateParametersInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.RunbookListResult;
import com.azure.resourcemanager.automation.models.RunbookUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RunbooksClientImpl
implements RunbooksClient {
    private final RunbooksService service;
    private final AutomationClientImpl client;

    RunbooksClientImpl(AutomationClientImpl client) {
        this.service = (RunbooksService)RestProxy.create(RunbooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> publishWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.publish(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> publishWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.publish(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPublishAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.publishWithResponseAsync(resourceGroupName, automationAccountName, runbookName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPublishAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.publishWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPublish(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.beginPublishAsync(resourceGroupName, automationAccountName, runbookName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPublish(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.beginPublishAsync(resourceGroupName, automationAccountName, runbookName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> publishAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.beginPublishAsync(resourceGroupName, automationAccountName, runbookName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> publishAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.beginPublishAsync(resourceGroupName, automationAccountName, runbookName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void publish(String resourceGroupName, String automationAccountName, String runbookName) {
        this.publishAsync(resourceGroupName, automationAccountName, runbookName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void publish(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        this.publishAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "text/powershell";
        return FluxUtil.withContext(context -> this.service.getContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "text/powershell", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getContentWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "text/powershell";
        context = this.client.mergeContext(context);
        return this.service.getContent(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "text/powershell", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Flux<ByteBuffer>> getContentAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.getContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((Flux)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Flux<ByteBuffer>> getContentWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.getContentWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getContent(String resourceGroupName, String automationAccountName, String runbookName) {
        return (Flux)this.getContentWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunbookInner> getAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RunbookInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunbookInner> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunbookInner get(String resourceGroupName, String automationAccountName, String runbookName) {
        return (RunbookInner)((Object)this.getWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookCreateOrUpdateParametersInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookCreateOrUpdateParametersInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunbookInner> createOrUpdateAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookCreateOrUpdateParametersInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RunbookInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunbookInner> createOrUpdateWithResponse(String resourceGroupName, String automationAccountName, String runbookName, RunbookCreateOrUpdateParametersInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunbookInner createOrUpdate(String resourceGroupName, String automationAccountName, String runbookName, RunbookCreateOrUpdateParametersInner parameters) {
        return (RunbookInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, automationAccountName, runbookName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> updateWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunbookInner>> updateWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RunbookInner> updateAsync(String resourceGroupName, String automationAccountName, String runbookName, RunbookUpdateParameters parameters) {
        return this.updateWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RunbookInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunbookInner> updateWithResponse(String resourceGroupName, String automationAccountName, String runbookName, RunbookUpdateParameters parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunbookInner update(String resourceGroupName, String automationAccountName, String runbookName, RunbookUpdateParameters parameters) {
        return (RunbookInner)((Object)this.updateWithResponse(resourceGroupName, automationAccountName, runbookName, parameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.deleteWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String automationAccountName, String runbookName) {
        this.deleteWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunbookInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccount(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2018-06-30", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunbookListResult)res.getValue()).value(), ((RunbookListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunbookInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccount(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2018-06-30", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunbookListResult)res.getValue()).value(), ((RunbookListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RunbookInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RunbookInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, Context context) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, context), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunbookInner> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunbookInner> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunbookInner>> listByAutomationAccountNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunbookListResult)res.getValue()).value(), ((RunbookListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunbookInner>> listByAutomationAccountNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunbookListResult)res.getValue()).value(), ((RunbookListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientRunb")
    public static interface RunbooksService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/publish")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> publish(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/content")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getContent(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RunbookCreateOrUpdateParametersInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") RunbookUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookListResult>> listByAutomationAccount(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunbookListResult>> listByAutomationAccountNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

