/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.RunbooksClient;
import com.azure.resourcemanager.automation.fluent.models.RunbookInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.RunbookImpl;
import com.azure.resourcemanager.automation.models.Runbook;
import com.azure.resourcemanager.automation.models.Runbooks;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class RunbooksImpl
implements Runbooks {
    private static final ClientLogger LOGGER = new ClientLogger(RunbooksImpl.class);
    private final RunbooksClient innerClient;
    private final AutomationManager serviceManager;

    public RunbooksImpl(RunbooksClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void publish(String resourceGroupName, String automationAccountName, String runbookName) {
        this.serviceClient().publish(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public void publish(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        this.serviceClient().publish(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public Response<Flux<ByteBuffer>> getContentWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().getContentWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public Flux<ByteBuffer> getContent(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.serviceClient().getContent(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public Response<Runbook> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        Response<RunbookInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, runbookName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RunbookImpl((RunbookInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Runbook get(String resourceGroupName, String automationAccountName, String runbookName) {
        RunbookInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, runbookName);
        if (inner != null) {
            return new RunbookImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String runbookName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public PagedIterable<Runbook> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<RunbookInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RunbookImpl((RunbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Runbook> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<RunbookInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RunbookImpl((RunbookInner)((Object)inner1), this.manager()));
    }

    @Override
    public Runbook getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String runbookName = ResourceManagerUtils.getValueFromIdByName(id, "runbooks");
        if (runbookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'runbooks'.", id)));
        }
        return (Runbook)this.getWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @Override
    public Response<Runbook> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String runbookName = ResourceManagerUtils.getValueFromIdByName(id, "runbooks");
        if (runbookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'runbooks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String runbookName = ResourceManagerUtils.getValueFromIdByName(id, "runbooks");
        if (runbookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'runbooks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String runbookName = ResourceManagerUtils.getValueFromIdByName(id, "runbooks");
        if (runbookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'runbooks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    private RunbooksClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public RunbookImpl define(String name) {
        return new RunbookImpl(name, this.manager());
    }
}

