/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.ScheduleInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.Schedule;
import com.azure.resourcemanager.automation.models.ScheduleCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import com.azure.resourcemanager.automation.models.ScheduleUpdateParameters;
import java.time.OffsetDateTime;

public final class ScheduleImpl
implements Schedule,
Schedule.Definition,
Schedule.Update {
    private ScheduleInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String scheduleName;
    private ScheduleCreateOrUpdateParameters createParameters;
    private ScheduleUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.innerModel().startTime();
    }

    @Override
    public Double startTimeOffsetMinutes() {
        return this.innerModel().startTimeOffsetMinutes();
    }

    @Override
    public OffsetDateTime expiryTime() {
        return this.innerModel().expiryTime();
    }

    @Override
    public Double expiryTimeOffsetMinutes() {
        return this.innerModel().expiryTimeOffsetMinutes();
    }

    @Override
    public Boolean isEnabled() {
        return this.innerModel().isEnabled();
    }

    @Override
    public OffsetDateTime nextRun() {
        return this.innerModel().nextRun();
    }

    @Override
    public Double nextRunOffsetMinutes() {
        return this.innerModel().nextRunOffsetMinutes();
    }

    @Override
    public Object interval() {
        return this.innerModel().interval();
    }

    @Override
    public ScheduleFrequency frequency() {
        return this.innerModel().frequency();
    }

    @Override
    public String timeZone() {
        return this.innerModel().timeZone();
    }

    @Override
    public AdvancedSchedule advancedSchedule() {
        return this.innerModel().advancedSchedule();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ScheduleInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScheduleImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Schedule create() {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Schedule create(Context context) {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, this.createParameters, context).getValue());
        return this;
    }

    ScheduleImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new ScheduleInner();
        this.serviceManager = serviceManager;
        this.scheduleName = name;
        this.createParameters = new ScheduleCreateOrUpdateParameters();
    }

    @Override
    public ScheduleImpl update() {
        this.updateParameters = new ScheduleUpdateParameters();
        return this;
    }

    @Override
    public Schedule apply() {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Schedule apply(Context context) {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, this.updateParameters, context).getValue());
        return this;
    }

    ScheduleImpl(ScheduleInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.scheduleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schedules");
    }

    @Override
    public Schedule refresh() {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().getWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Schedule refresh(Context context) {
        this.innerObject = (ScheduleInner)((Object)this.serviceManager.serviceClient().getSchedules().getWithResponse(this.resourceGroupName, this.automationAccountName, this.scheduleName, context).getValue());
        return this;
    }

    @Override
    public ScheduleImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public ScheduleImpl withStartTime(OffsetDateTime startTime) {
        this.createParameters.withStartTime(startTime);
        return this;
    }

    @Override
    public ScheduleImpl withFrequency(ScheduleFrequency frequency) {
        this.createParameters.withFrequency(frequency);
        return this;
    }

    @Override
    public ScheduleImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public ScheduleImpl withExpiryTime(OffsetDateTime expiryTime) {
        this.createParameters.withExpiryTime(expiryTime);
        return this;
    }

    @Override
    public ScheduleImpl withInterval(Object interval) {
        this.createParameters.withInterval(interval);
        return this;
    }

    @Override
    public ScheduleImpl withTimeZone(String timeZone) {
        this.createParameters.withTimeZone(timeZone);
        return this;
    }

    @Override
    public ScheduleImpl withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        this.createParameters.withAdvancedSchedule(advancedSchedule);
        return this;
    }

    @Override
    public ScheduleImpl withIsEnabled(Boolean isEnabled) {
        this.updateParameters.withIsEnabled(isEnabled);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

