/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SchedulesClient;
import com.azure.resourcemanager.automation.fluent.models.ScheduleInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.ScheduleImpl;
import com.azure.resourcemanager.automation.models.Schedule;
import com.azure.resourcemanager.automation.models.Schedules;

public final class SchedulesImpl
implements Schedules {
    private static final ClientLogger LOGGER = new ClientLogger(SchedulesImpl.class);
    private final SchedulesClient innerClient;
    private final AutomationManager serviceManager;

    public SchedulesImpl(SchedulesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Schedule> getWithResponse(String resourceGroupName, String automationAccountName, String scheduleName, Context context) {
        Response<ScheduleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, scheduleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScheduleImpl((ScheduleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Schedule get(String resourceGroupName, String automationAccountName, String scheduleName) {
        ScheduleInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, scheduleName);
        if (inner != null) {
            return new ScheduleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String scheduleName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, scheduleName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String scheduleName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, scheduleName);
    }

    @Override
    public PagedIterable<Schedule> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<ScheduleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduleImpl((ScheduleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Schedule> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<ScheduleInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScheduleImpl((ScheduleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Schedule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String scheduleName = ResourceManagerUtils.getValueFromIdByName(id, "schedules");
        if (scheduleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedules'.", id)));
        }
        return (Schedule)this.getWithResponse(resourceGroupName, automationAccountName, scheduleName, Context.NONE).getValue();
    }

    @Override
    public Response<Schedule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String scheduleName = ResourceManagerUtils.getValueFromIdByName(id, "schedules");
        if (scheduleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, scheduleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String scheduleName = ResourceManagerUtils.getValueFromIdByName(id, "schedules");
        if (scheduleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedules'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, scheduleName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String scheduleName = ResourceManagerUtils.getValueFromIdByName(id, "schedules");
        if (scheduleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedules'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, scheduleName, context);
    }

    private SchedulesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScheduleImpl define(String name) {
        return new ScheduleImpl(name, this.manager());
    }
}

