/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationInner;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfiguration;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationTasks;
import com.azure.resourcemanager.automation.models.SucScheduleProperties;
import com.azure.resourcemanager.automation.models.UpdateConfiguration;
import java.time.OffsetDateTime;

public final class SoftwareUpdateConfigurationImpl
implements SoftwareUpdateConfiguration,
SoftwareUpdateConfiguration.Definition {
    private SoftwareUpdateConfigurationInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String softwareUpdateConfigurationName;
    private String createClientRequestId;

    SoftwareUpdateConfigurationImpl(SoftwareUpdateConfigurationInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public UpdateConfiguration updateConfiguration() {
        return this.innerModel().updateConfiguration();
    }

    @Override
    public SucScheduleProperties scheduleInfo() {
        return this.innerModel().scheduleInfo();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public ManagementError error() {
        return this.innerModel().error();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public String createdBy() {
        return this.innerModel().createdBy();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public SoftwareUpdateConfigurationTasks tasks() {
        return this.innerModel().tasks();
    }

    @Override
    public SoftwareUpdateConfigurationInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public SoftwareUpdateConfiguration create() {
        this.innerObject = (SoftwareUpdateConfigurationInner)((Object)this.serviceManager.serviceClient().getSoftwareUpdateConfigurations().createWithResponse(this.resourceGroupName, this.automationAccountName, this.softwareUpdateConfigurationName, this.innerModel(), this.createClientRequestId, Context.NONE).getValue());
        return this;
    }

    @Override
    public SoftwareUpdateConfiguration create(Context context) {
        this.innerObject = (SoftwareUpdateConfigurationInner)((Object)this.serviceManager.serviceClient().getSoftwareUpdateConfigurations().createWithResponse(this.resourceGroupName, this.automationAccountName, this.softwareUpdateConfigurationName, this.innerModel(), this.createClientRequestId, context).getValue());
        return this;
    }

    SoftwareUpdateConfigurationImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new SoftwareUpdateConfigurationInner();
        this.serviceManager = serviceManager;
        this.softwareUpdateConfigurationName = name;
        this.createClientRequestId = null;
    }

    @Override
    public SoftwareUpdateConfiguration refresh() {
        String localClientRequestId = null;
        this.innerObject = (SoftwareUpdateConfigurationInner)((Object)this.serviceManager.serviceClient().getSoftwareUpdateConfigurations().getByNameWithResponse(this.resourceGroupName, this.automationAccountName, this.softwareUpdateConfigurationName, localClientRequestId, Context.NONE).getValue());
        return this;
    }

    @Override
    public SoftwareUpdateConfiguration refresh(Context context) {
        String localClientRequestId = null;
        this.innerObject = (SoftwareUpdateConfigurationInner)((Object)this.serviceManager.serviceClient().getSoftwareUpdateConfigurations().getByNameWithResponse(this.resourceGroupName, this.automationAccountName, this.softwareUpdateConfigurationName, localClientRequestId, context).getValue());
        return this;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withUpdateConfiguration(UpdateConfiguration updateConfiguration) {
        this.innerModel().withUpdateConfiguration(updateConfiguration);
        return this;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withScheduleInfo(SucScheduleProperties scheduleInfo) {
        this.innerModel().withScheduleInfo(scheduleInfo);
        return this;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withError(ManagementError error) {
        this.innerModel().withError(error);
        return this;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withTasks(SoftwareUpdateConfigurationTasks tasks) {
        this.innerModel().withTasks(tasks);
        return this;
    }

    @Override
    public SoftwareUpdateConfigurationImpl withClientRequestId(String clientRequestId) {
        this.createClientRequestId = clientRequestId;
        return this;
    }
}

