/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationMachineRunsClient;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationMachineRunInner;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationMachineRunListResultInner;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationMachineRunImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationMachineRunListResultImpl;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationMachineRun;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationMachineRunListResult;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationMachineRuns;
import java.util.UUID;

public final class SoftwareUpdateConfigurationMachineRunsImpl
implements SoftwareUpdateConfigurationMachineRuns {
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationMachineRunsImpl.class);
    private final SoftwareUpdateConfigurationMachineRunsClient innerClient;
    private final AutomationManager serviceManager;

    public SoftwareUpdateConfigurationMachineRunsImpl(SoftwareUpdateConfigurationMachineRunsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SoftwareUpdateConfigurationMachineRun> getByIdWithResponse(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationMachineRunId, String clientRequestId, Context context) {
        Response<SoftwareUpdateConfigurationMachineRunInner> inner = this.serviceClient().getByIdWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationMachineRunId, clientRequestId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationMachineRunImpl((SoftwareUpdateConfigurationMachineRunInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfigurationMachineRun getById(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationMachineRunId) {
        SoftwareUpdateConfigurationMachineRunInner inner = this.serviceClient().getById(resourceGroupName, automationAccountName, softwareUpdateConfigurationMachineRunId);
        if (inner != null) {
            return new SoftwareUpdateConfigurationMachineRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SoftwareUpdateConfigurationMachineRunListResult> listWithResponse(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, String skip, String top, Context context) {
        Response<SoftwareUpdateConfigurationMachineRunListResultInner> inner = this.serviceClient().listWithResponse(resourceGroupName, automationAccountName, clientRequestId, filter, skip, top, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationMachineRunListResultImpl((SoftwareUpdateConfigurationMachineRunListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfigurationMachineRunListResult list(String resourceGroupName, String automationAccountName) {
        SoftwareUpdateConfigurationMachineRunListResultInner inner = this.serviceClient().list(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new SoftwareUpdateConfigurationMachineRunListResultImpl(inner, this.manager());
        }
        return null;
    }

    private SoftwareUpdateConfigurationMachineRunsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

