/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationRunsClient;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationRunInner;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationRunListResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SoftwareUpdateConfigurationRunsClientImpl
implements SoftwareUpdateConfigurationRunsClient {
    private final SoftwareUpdateConfigurationRunsService service;
    private final AutomationClientImpl client;

    SoftwareUpdateConfigurationRunsClientImpl(AutomationClientImpl client) {
        this.service = (SoftwareUpdateConfigurationRunsService)RestProxy.create(SoftwareUpdateConfigurationRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationRunInner>> getByIdWithResponseAsync(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationRunId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationRunId is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getById(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, "2019-06-01", clientRequestId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationRunInner>> getByIdWithResponseAsync(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationRunId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationRunId is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getById(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, "2019-06-01", clientRequestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SoftwareUpdateConfigurationRunInner> getByIdAsync(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId) {
        String clientRequestId = null;
        return this.getByIdWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((SoftwareUpdateConfigurationRunInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SoftwareUpdateConfigurationRunInner> getByIdWithResponse(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId, String clientRequestId, Context context) {
        return (Response)this.getByIdWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SoftwareUpdateConfigurationRunInner getById(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId) {
        String clientRequestId = null;
        return (SoftwareUpdateConfigurationRunInner)this.getByIdWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, clientRequestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationRunListResultInner>> listWithResponseAsync(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, String skip, String top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2019-06-01", clientRequestId, filter, skip, top, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationRunListResultInner>> listWithResponseAsync(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, String skip, String top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2019-06-01", clientRequestId, filter, skip, top, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SoftwareUpdateConfigurationRunListResultInner> listAsync(String resourceGroupName, String automationAccountName) {
        String clientRequestId = null;
        String filter = null;
        String skip = null;
        String top = null;
        return this.listWithResponseAsync(resourceGroupName, automationAccountName, clientRequestId, filter, skip, top).flatMap(res -> Mono.justOrEmpty((Object)((SoftwareUpdateConfigurationRunListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SoftwareUpdateConfigurationRunListResultInner> listWithResponse(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, String skip, String top, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, automationAccountName, clientRequestId, filter, skip, top, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SoftwareUpdateConfigurationRunListResultInner list(String resourceGroupName, String automationAccountName) {
        String clientRequestId = null;
        String filter = null;
        String skip = null;
        String top = null;
        return (SoftwareUpdateConfigurationRunListResultInner)this.listWithResponse(resourceGroupName, automationAccountName, clientRequestId, filter, skip, top, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientSoft")
    public static interface SoftwareUpdateConfigurationRunsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationRuns/{softwareUpdateConfigurationRunId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SoftwareUpdateConfigurationRunInner>> getById(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="softwareUpdateConfigurationRunId") UUID var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="clientRequestId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurationRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SoftwareUpdateConfigurationRunListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="clientRequestId") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$skip") String var8, @QueryParam(value="$top") String var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

