/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationRunsClient;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationRunInner;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationRunListResultInner;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationRunImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationRunListResultImpl;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationRun;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationRunListResult;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationRuns;
import java.util.UUID;

public final class SoftwareUpdateConfigurationRunsImpl
implements SoftwareUpdateConfigurationRuns {
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationRunsImpl.class);
    private final SoftwareUpdateConfigurationRunsClient innerClient;
    private final AutomationManager serviceManager;

    public SoftwareUpdateConfigurationRunsImpl(SoftwareUpdateConfigurationRunsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SoftwareUpdateConfigurationRun> getByIdWithResponse(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId, String clientRequestId, Context context) {
        Response<SoftwareUpdateConfigurationRunInner> inner = this.serviceClient().getByIdWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId, clientRequestId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationRunImpl((SoftwareUpdateConfigurationRunInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfigurationRun getById(String resourceGroupName, String automationAccountName, UUID softwareUpdateConfigurationRunId) {
        SoftwareUpdateConfigurationRunInner inner = this.serviceClient().getById(resourceGroupName, automationAccountName, softwareUpdateConfigurationRunId);
        if (inner != null) {
            return new SoftwareUpdateConfigurationRunImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SoftwareUpdateConfigurationRunListResult> listWithResponse(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, String skip, String top, Context context) {
        Response<SoftwareUpdateConfigurationRunListResultInner> inner = this.serviceClient().listWithResponse(resourceGroupName, automationAccountName, clientRequestId, filter, skip, top, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationRunListResultImpl((SoftwareUpdateConfigurationRunListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfigurationRunListResult list(String resourceGroupName, String automationAccountName) {
        SoftwareUpdateConfigurationRunListResultInner inner = this.serviceClient().list(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new SoftwareUpdateConfigurationRunListResultImpl(inner, this.manager());
        }
        return null;
    }

    private SoftwareUpdateConfigurationRunsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

