/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationInner;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationListResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import reactor.core.publisher.Mono;

public final class SoftwareUpdateConfigurationsClientImpl
implements SoftwareUpdateConfigurationsClient {
    private final SoftwareUpdateConfigurationsService service;
    private final AutomationClientImpl client;

    SoftwareUpdateConfigurationsClientImpl(AutomationClientImpl client) {
        this.service = (SoftwareUpdateConfigurationsService)RestProxy.create(SoftwareUpdateConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, SoftwareUpdateConfigurationInner parameters, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, SoftwareUpdateConfigurationInner parameters, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SoftwareUpdateConfigurationInner> createAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, SoftwareUpdateConfigurationInner parameters) {
        String clientRequestId = null;
        return this.createWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, parameters, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SoftwareUpdateConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SoftwareUpdateConfigurationInner> createWithResponse(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, SoftwareUpdateConfigurationInner parameters, String clientRequestId, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, parameters, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SoftwareUpdateConfigurationInner create(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, SoftwareUpdateConfigurationInner parameters) {
        String clientRequestId = null;
        return (SoftwareUpdateConfigurationInner)((Object)this.createWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, parameters, clientRequestId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationInner>> getByNameWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationInner>> getByNameWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByName(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SoftwareUpdateConfigurationInner> getByNameAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        String clientRequestId = null;
        return this.getByNameWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SoftwareUpdateConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SoftwareUpdateConfigurationInner> getByNameWithResponse(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        return (Response)this.getByNameWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SoftwareUpdateConfigurationInner getByName(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        String clientRequestId = null;
        return (SoftwareUpdateConfigurationInner)((Object)this.getByNameWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (softwareUpdateConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter softwareUpdateConfigurationName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, softwareUpdateConfigurationName, "2019-06-01", clientRequestId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        String clientRequestId = null;
        return this.deleteWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        String clientRequestId = null;
        this.deleteWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationListResultInner>> listWithResponseAsync(String resourceGroupName, String automationAccountName, String clientRequestId, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2019-06-01", clientRequestId, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SoftwareUpdateConfigurationListResultInner>> listWithResponseAsync(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        String apiVersion = "2019-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, "2019-06-01", clientRequestId, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SoftwareUpdateConfigurationListResultInner> listAsync(String resourceGroupName, String automationAccountName) {
        String clientRequestId = null;
        String filter = null;
        return this.listWithResponseAsync(resourceGroupName, automationAccountName, clientRequestId, filter).flatMap(res -> Mono.justOrEmpty((Object)((SoftwareUpdateConfigurationListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SoftwareUpdateConfigurationListResultInner> listWithResponse(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, automationAccountName, clientRequestId, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SoftwareUpdateConfigurationListResultInner list(String resourceGroupName, String automationAccountName) {
        String clientRequestId = null;
        String filter = null;
        return (SoftwareUpdateConfigurationListResultInner)this.listWithResponse(resourceGroupName, automationAccountName, clientRequestId, filter, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientSoft")
    public static interface SoftwareUpdateConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SoftwareUpdateConfigurationInner>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="softwareUpdateConfigurationName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="clientRequestId") String var7, @BodyParam(value="application/json") SoftwareUpdateConfigurationInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SoftwareUpdateConfigurationInner>> getByName(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="softwareUpdateConfigurationName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="clientRequestId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations/{softwareUpdateConfigurationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="softwareUpdateConfigurationName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="clientRequestId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/softwareUpdateConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SoftwareUpdateConfigurationListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="clientRequestId") String var6, @QueryParam(value="$filter") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

