/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SoftwareUpdateConfigurationsClient;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationInner;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationListResultInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationImpl;
import com.azure.resourcemanager.automation.implementation.SoftwareUpdateConfigurationListResultImpl;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfiguration;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationListResult;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurations;

public final class SoftwareUpdateConfigurationsImpl
implements SoftwareUpdateConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationsImpl.class);
    private final SoftwareUpdateConfigurationsClient innerClient;
    private final AutomationManager serviceManager;

    public SoftwareUpdateConfigurationsImpl(SoftwareUpdateConfigurationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SoftwareUpdateConfiguration> getByNameWithResponse(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        Response<SoftwareUpdateConfigurationInner> inner = this.serviceClient().getByNameWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationImpl((SoftwareUpdateConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfiguration getByName(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        SoftwareUpdateConfigurationInner inner = this.serviceClient().getByName(resourceGroupName, automationAccountName, softwareUpdateConfigurationName);
        if (inner != null) {
            return new SoftwareUpdateConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName, String clientRequestId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String softwareUpdateConfigurationName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, softwareUpdateConfigurationName);
    }

    @Override
    public Response<SoftwareUpdateConfigurationListResult> listWithResponse(String resourceGroupName, String automationAccountName, String clientRequestId, String filter, Context context) {
        Response<SoftwareUpdateConfigurationListResultInner> inner = this.serviceClient().listWithResponse(resourceGroupName, automationAccountName, clientRequestId, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SoftwareUpdateConfigurationListResultImpl((SoftwareUpdateConfigurationListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfigurationListResult list(String resourceGroupName, String automationAccountName) {
        SoftwareUpdateConfigurationListResultInner inner = this.serviceClient().list(resourceGroupName, automationAccountName);
        if (inner != null) {
            return new SoftwareUpdateConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SoftwareUpdateConfiguration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String softwareUpdateConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "softwareUpdateConfigurations");
        if (softwareUpdateConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'softwareUpdateConfigurations'.", id)));
        }
        String localClientRequestId = null;
        return (SoftwareUpdateConfiguration)this.getByNameWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, localClientRequestId, Context.NONE).getValue();
    }

    @Override
    public Response<SoftwareUpdateConfiguration> getByIdWithResponse(String id, String clientRequestId, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String softwareUpdateConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "softwareUpdateConfigurations");
        if (softwareUpdateConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'softwareUpdateConfigurations'.", id)));
        }
        return this.getByNameWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String softwareUpdateConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "softwareUpdateConfigurations");
        if (softwareUpdateConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'softwareUpdateConfigurations'.", id)));
        }
        String localClientRequestId = null;
        this.deleteWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, localClientRequestId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, String clientRequestId, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String softwareUpdateConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "softwareUpdateConfigurations");
        if (softwareUpdateConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'softwareUpdateConfigurations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, softwareUpdateConfigurationName, clientRequestId, context);
    }

    private SoftwareUpdateConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SoftwareUpdateConfigurationImpl define(String name) {
        return new SoftwareUpdateConfigurationImpl(name, this.manager());
    }
}

