/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.SourceControlInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.SourceControl;
import com.azure.resourcemanager.automation.models.SourceControlCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.SourceControlSecurityTokenProperties;
import com.azure.resourcemanager.automation.models.SourceControlUpdateParameters;
import com.azure.resourcemanager.automation.models.SourceType;
import java.time.OffsetDateTime;

public final class SourceControlImpl
implements SourceControl,
SourceControl.Definition,
SourceControl.Update {
    private SourceControlInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String sourceControlName;
    private SourceControlCreateOrUpdateParameters createParameters;
    private SourceControlUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String repoUrl() {
        return this.innerModel().repoUrl();
    }

    @Override
    public String branch() {
        return this.innerModel().branch();
    }

    @Override
    public String folderPath() {
        return this.innerModel().folderPath();
    }

    @Override
    public Boolean autoSync() {
        return this.innerModel().autoSync();
    }

    @Override
    public Boolean publishRunbook() {
        return this.innerModel().publishRunbook();
    }

    @Override
    public SourceType sourceType() {
        return this.innerModel().sourceType();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SourceControlInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public SourceControl create() {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public SourceControl create(Context context) {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.createParameters, context).getValue());
        return this;
    }

    SourceControlImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new SourceControlInner();
        this.serviceManager = serviceManager;
        this.sourceControlName = name;
        this.createParameters = new SourceControlCreateOrUpdateParameters();
    }

    @Override
    public SourceControlImpl update() {
        this.updateParameters = new SourceControlUpdateParameters();
        return this;
    }

    @Override
    public SourceControl apply() {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public SourceControl apply(Context context) {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.updateParameters, context).getValue());
        return this;
    }

    SourceControlImpl(SourceControlInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.sourceControlName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sourceControls");
    }

    @Override
    public SourceControl refresh() {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().getWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SourceControl refresh(Context context) {
        this.innerObject = (SourceControlInner)((Object)this.serviceManager.serviceClient().getSourceControls().getWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, context).getValue());
        return this;
    }

    @Override
    public SourceControlImpl withRepoUrl(String repoUrl) {
        this.createParameters.withRepoUrl(repoUrl);
        return this;
    }

    @Override
    public SourceControlImpl withBranch(String branch) {
        if (this.isInCreateMode()) {
            this.createParameters.withBranch(branch);
            return this;
        }
        this.updateParameters.withBranch(branch);
        return this;
    }

    @Override
    public SourceControlImpl withFolderPath(String folderPath) {
        if (this.isInCreateMode()) {
            this.createParameters.withFolderPath(folderPath);
            return this;
        }
        this.updateParameters.withFolderPath(folderPath);
        return this;
    }

    @Override
    public SourceControlImpl withAutoSync(Boolean autoSync) {
        if (this.isInCreateMode()) {
            this.createParameters.withAutoSync(autoSync);
            return this;
        }
        this.updateParameters.withAutoSync(autoSync);
        return this;
    }

    @Override
    public SourceControlImpl withPublishRunbook(Boolean publishRunbook) {
        if (this.isInCreateMode()) {
            this.createParameters.withPublishRunbook(publishRunbook);
            return this;
        }
        this.updateParameters.withPublishRunbook(publishRunbook);
        return this;
    }

    @Override
    public SourceControlImpl withSourceType(SourceType sourceType) {
        this.createParameters.withSourceType(sourceType);
        return this;
    }

    @Override
    public SourceControlImpl withSecurityToken(SourceControlSecurityTokenProperties securityToken) {
        if (this.isInCreateMode()) {
            this.createParameters.withSecurityToken(securityToken);
            return this;
        }
        this.updateParameters.withSecurityToken(securityToken);
        return this;
    }

    @Override
    public SourceControlImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

