/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobInner;
import com.azure.resourcemanager.automation.models.ProvisioningState;
import com.azure.resourcemanager.automation.models.SourceControlSyncJob;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobCreateParameters;
import com.azure.resourcemanager.automation.models.SyncType;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class SourceControlSyncJobImpl
implements SourceControlSyncJob,
SourceControlSyncJob.Definition {
    private SourceControlSyncJobInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String sourceControlName;
    private UUID sourceControlSyncJobId;
    private SourceControlSyncJobCreateParameters createParameters;

    SourceControlSyncJobImpl(SourceControlSyncJobInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String sourceControlSyncJobId() {
        return this.innerModel().sourceControlSyncJobId();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime startTime() {
        return this.innerModel().startTime();
    }

    @Override
    public OffsetDateTime endTime() {
        return this.innerModel().endTime();
    }

    @Override
    public SyncType syncType() {
        return this.innerModel().syncType();
    }

    @Override
    public SourceControlSyncJobInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlSyncJobImpl withExistingSourceControl(String resourceGroupName, String automationAccountName, String sourceControlName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        this.sourceControlName = sourceControlName;
        return this;
    }

    @Override
    public SourceControlSyncJob create() {
        this.innerObject = (SourceControlSyncJobInner)this.serviceManager.serviceClient().getSourceControlSyncJobs().createWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.sourceControlSyncJobId, this.createParameters, Context.NONE).getValue();
        return this;
    }

    @Override
    public SourceControlSyncJob create(Context context) {
        this.innerObject = (SourceControlSyncJobInner)this.serviceManager.serviceClient().getSourceControlSyncJobs().createWithResponse(this.resourceGroupName, this.automationAccountName, this.sourceControlName, this.sourceControlSyncJobId, this.createParameters, context).getValue();
        return this;
    }

    SourceControlSyncJobImpl(UUID name, AutomationManager serviceManager) {
        this.innerObject = new SourceControlSyncJobInner();
        this.serviceManager = serviceManager;
        this.sourceControlSyncJobId = name;
        this.createParameters = new SourceControlSyncJobCreateParameters();
    }

    @Override
    public SourceControlSyncJobImpl withCommitId(String commitId) {
        this.createParameters.withCommitId(commitId);
        return this;
    }
}

