/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobStreamByIdInner;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobStreamInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobStreamsListBySyncJob;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SourceControlSyncJobStreamsClientImpl
implements SourceControlSyncJobStreamsClient {
    private final SourceControlSyncJobStreamsService service;
    private final AutomationClientImpl client;

    SourceControlSyncJobStreamsClientImpl(AutomationClientImpl client) {
        this.service = (SourceControlSyncJobStreamsService)RestProxy.create(SourceControlSyncJobStreamsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobStreamInner>> listBySyncJobSinglePageAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySyncJob(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).value(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobStreamInner>> listBySyncJobSinglePageAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySyncJob(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).value(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobStreamInner> listBySyncJobAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter) {
        return new PagedFlux(() -> this.listBySyncJobSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter), nextLink -> this.listBySyncJobNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobStreamInner> listBySyncJobAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        String filter = null;
        return new PagedFlux(() -> this.listBySyncJobSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter), nextLink -> this.listBySyncJobNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobStreamInner> listBySyncJobAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter, Context context) {
        return new PagedFlux(() -> this.listBySyncJobSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter, context), nextLink -> this.listBySyncJobNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlSyncJobStreamInner> listBySyncJob(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        String filter = null;
        return new PagedIterable(this.listBySyncJobAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlSyncJobStreamInner> listBySyncJob(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter, Context context) {
        return new PagedIterable(this.listBySyncJobAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobStreamByIdInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (streamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter streamId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobStreamByIdInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (streamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter streamId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlSyncJobStreamByIdInner> getAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId).flatMap(res -> Mono.justOrEmpty((Object)((SourceControlSyncJobStreamByIdInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SourceControlSyncJobStreamByIdInner> getWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlSyncJobStreamByIdInner get(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId) {
        return (SourceControlSyncJobStreamByIdInner)this.getWithResponse(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobStreamInner>> listBySyncJobNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySyncJobNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).value(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobStreamInner>> listBySyncJobNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySyncJobNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).value(), ((SourceControlSyncJobStreamsListBySyncJob)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientSour")
    public static interface SourceControlSyncJobStreamsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}/streams")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobStreamsListBySyncJob>> listBySyncJob(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="sourceControlName") String var4, @PathParam(value="sourceControlSyncJobId") UUID var5, @QueryParam(value="$filter") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}/streams/{streamId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobStreamByIdInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="sourceControlName") String var4, @PathParam(value="sourceControlSyncJobId") UUID var5, @PathParam(value="streamId") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobStreamsListBySyncJob>> listBySyncJobNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

