/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobStreamByIdInner;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobStreamInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobStreamByIdImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobStreamImpl;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobStream;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobStreamById;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobStreams;
import java.util.UUID;

public final class SourceControlSyncJobStreamsImpl
implements SourceControlSyncJobStreams {
    private static final ClientLogger LOGGER = new ClientLogger(SourceControlSyncJobStreamsImpl.class);
    private final SourceControlSyncJobStreamsClient innerClient;
    private final AutomationManager serviceManager;

    public SourceControlSyncJobStreamsImpl(SourceControlSyncJobStreamsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SourceControlSyncJobStream> listBySyncJob(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        PagedIterable<SourceControlSyncJobStreamInner> inner = this.serviceClient().listBySyncJob(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlSyncJobStreamImpl((SourceControlSyncJobStreamInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SourceControlSyncJobStream> listBySyncJob(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String filter, Context context) {
        PagedIterable<SourceControlSyncJobStreamInner> inner = this.serviceClient().listBySyncJob(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlSyncJobStreamImpl((SourceControlSyncJobStreamInner)inner1, this.manager()));
    }

    @Override
    public Response<SourceControlSyncJobStreamById> getWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId, Context context) {
        Response<SourceControlSyncJobStreamByIdInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SourceControlSyncJobStreamByIdImpl((SourceControlSyncJobStreamByIdInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SourceControlSyncJobStreamById get(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, String streamId) {
        SourceControlSyncJobStreamByIdInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, streamId);
        if (inner != null) {
            return new SourceControlSyncJobStreamByIdImpl(inner, this.manager());
        }
        return null;
    }

    private SourceControlSyncJobStreamsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

