/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobsClient;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobByIdInner;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobCreateParameters;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobListResult;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SourceControlSyncJobsClientImpl
implements SourceControlSyncJobsClient {
    private final SourceControlSyncJobsService service;
    private final AutomationClientImpl client;

    SourceControlSyncJobsClientImpl(AutomationClientImpl client) {
        this.service = (SourceControlSyncJobsService)RestProxy.create(SourceControlSyncJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, SourceControlSyncJobCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, this.client.getSubscriptionId(), "2020-01-13-preview", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, SourceControlSyncJobCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, this.client.getSubscriptionId(), "2020-01-13-preview", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlSyncJobInner> createAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, SourceControlSyncJobCreateParameters parameters) {
        return this.createWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, parameters).flatMap(res -> Mono.justOrEmpty((Object)((SourceControlSyncJobInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SourceControlSyncJobInner> createWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, SourceControlSyncJobCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlSyncJobInner create(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, SourceControlSyncJobCreateParameters parameters) {
        return (SourceControlSyncJobInner)this.createWithResponse(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobByIdInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SourceControlSyncJobByIdInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (sourceControlSyncJobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlSyncJobId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SourceControlSyncJobByIdInner> getAsync(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId).flatMap(res -> Mono.justOrEmpty((Object)((SourceControlSyncJobByIdInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SourceControlSyncJobByIdInner> getWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SourceControlSyncJobByIdInner get(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        return (SourceControlSyncJobByIdInner)this.getWithResponse(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName, String sourceControlName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobListResult)res.getValue()).value(), ((SourceControlSyncJobListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobInner>> listByAutomationAccountSinglePageAsync(String resourceGroupName, String automationAccountName, String sourceControlName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (sourceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceControlName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-13-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccount(this.client.getEndpoint(), resourceGroupName, automationAccountName, sourceControlName, filter, this.client.getSubscriptionId(), "2020-01-13-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobListResult)res.getValue()).value(), ((SourceControlSyncJobListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, String sourceControlName, String filter) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, filter), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, String sourceControlName) {
        String filter = null;
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, filter), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SourceControlSyncJobInner> listByAutomationAccountAsync(String resourceGroupName, String automationAccountName, String sourceControlName, String filter, Context context) {
        return new PagedFlux(() -> this.listByAutomationAccountSinglePageAsync(resourceGroupName, automationAccountName, sourceControlName, filter, context), nextLink -> this.listByAutomationAccountNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlSyncJobInner> listByAutomationAccount(String resourceGroupName, String automationAccountName, String sourceControlName) {
        String filter = null;
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName, sourceControlName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SourceControlSyncJobInner> listByAutomationAccount(String resourceGroupName, String automationAccountName, String sourceControlName, String filter, Context context) {
        return new PagedIterable(this.listByAutomationAccountAsync(resourceGroupName, automationAccountName, sourceControlName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobInner>> listByAutomationAccountNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobListResult)res.getValue()).value(), ((SourceControlSyncJobListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SourceControlSyncJobInner>> listByAutomationAccountNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAutomationAccountNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SourceControlSyncJobListResult)res.getValue()).value(), ((SourceControlSyncJobListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientSour")
    public static interface SourceControlSyncJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobInner>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="sourceControlName") String var4, @PathParam(value="sourceControlSyncJobId") UUID var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") SourceControlSyncJobCreateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs/{sourceControlSyncJobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobByIdInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="sourceControlName") String var4, @PathParam(value="sourceControlSyncJobId") UUID var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/sourceControls/{sourceControlName}/sourceControlSyncJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobListResult>> listByAutomationAccount(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="automationAccountName") String var3, @PathParam(value="sourceControlName") String var4, @QueryParam(value="$filter") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SourceControlSyncJobListResult>> listByAutomationAccountNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

