/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SourceControlSyncJobsClient;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobByIdInner;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobByIdImpl;
import com.azure.resourcemanager.automation.implementation.SourceControlSyncJobImpl;
import com.azure.resourcemanager.automation.models.SourceControlSyncJob;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobById;
import com.azure.resourcemanager.automation.models.SourceControlSyncJobs;
import java.util.UUID;

public final class SourceControlSyncJobsImpl
implements SourceControlSyncJobs {
    private static final ClientLogger LOGGER = new ClientLogger(SourceControlSyncJobsImpl.class);
    private final SourceControlSyncJobsClient innerClient;
    private final AutomationManager serviceManager;

    public SourceControlSyncJobsImpl(SourceControlSyncJobsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SourceControlSyncJobById> getWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId, Context context) {
        Response<SourceControlSyncJobByIdInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SourceControlSyncJobByIdImpl((SourceControlSyncJobByIdInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SourceControlSyncJobById get(String resourceGroupName, String automationAccountName, String sourceControlName, UUID sourceControlSyncJobId) {
        SourceControlSyncJobByIdInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, sourceControlName, sourceControlSyncJobId);
        if (inner != null) {
            return new SourceControlSyncJobByIdImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SourceControlSyncJob> listByAutomationAccount(String resourceGroupName, String automationAccountName, String sourceControlName) {
        PagedIterable<SourceControlSyncJobInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, sourceControlName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlSyncJobImpl((SourceControlSyncJobInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SourceControlSyncJob> listByAutomationAccount(String resourceGroupName, String automationAccountName, String sourceControlName, String filter, Context context) {
        PagedIterable<SourceControlSyncJobInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, sourceControlName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlSyncJobImpl((SourceControlSyncJobInner)inner1, this.manager()));
    }

    private SourceControlSyncJobsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlSyncJobImpl define(UUID name) {
        return new SourceControlSyncJobImpl(name, this.manager());
    }
}

