/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.SourceControlsClient;
import com.azure.resourcemanager.automation.fluent.models.SourceControlInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.SourceControlImpl;
import com.azure.resourcemanager.automation.models.SourceControl;
import com.azure.resourcemanager.automation.models.SourceControls;

public final class SourceControlsImpl
implements SourceControls {
    private static final ClientLogger LOGGER = new ClientLogger(SourceControlsImpl.class);
    private final SourceControlsClient innerClient;
    private final AutomationManager serviceManager;

    public SourceControlsImpl(SourceControlsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, sourceControlName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String sourceControlName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, sourceControlName);
    }

    @Override
    public Response<SourceControl> getWithResponse(String resourceGroupName, String automationAccountName, String sourceControlName, Context context) {
        Response<SourceControlInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, sourceControlName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SourceControlImpl((SourceControlInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SourceControl get(String resourceGroupName, String automationAccountName, String sourceControlName) {
        SourceControlInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, sourceControlName);
        if (inner != null) {
            return new SourceControlImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SourceControl> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<SourceControlInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlImpl((SourceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SourceControl> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<SourceControlInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SourceControlImpl((SourceControlInner)((Object)inner1), this.manager()));
    }

    @Override
    public SourceControl getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourceControls");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourceControls'.", id)));
        }
        return (SourceControl)this.getWithResponse(resourceGroupName, automationAccountName, sourceControlName, Context.NONE).getValue();
    }

    @Override
    public Response<SourceControl> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourceControls");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourceControls'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, sourceControlName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourceControls");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourceControls'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, sourceControlName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String sourceControlName = ResourceManagerUtils.getValueFromIdByName(id, "sourceControls");
        if (sourceControlName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sourceControls'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, sourceControlName, context);
    }

    private SourceControlsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SourceControlImpl define(String name) {
        return new SourceControlImpl(name, this.manager());
    }
}

