/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.StatisticsOperationsClient;
import com.azure.resourcemanager.automation.fluent.models.StatisticsInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.StatisticsImpl;
import com.azure.resourcemanager.automation.models.Statistics;
import com.azure.resourcemanager.automation.models.StatisticsOperations;

public final class StatisticsOperationsImpl
implements StatisticsOperations {
    private static final ClientLogger LOGGER = new ClientLogger(StatisticsOperationsImpl.class);
    private final StatisticsOperationsClient innerClient;
    private final AutomationManager serviceManager;

    public StatisticsOperationsImpl(StatisticsOperationsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Statistics> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<StatisticsInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StatisticsImpl((StatisticsInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Statistics> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<StatisticsInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new StatisticsImpl((StatisticsInner)inner1, this.manager()));
    }

    private StatisticsOperationsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

