/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.TestJobStreamsClient;
import com.azure.resourcemanager.automation.fluent.models.JobStreamInner;
import com.azure.resourcemanager.automation.fluent.models.JobStreamListResultInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import reactor.core.publisher.Mono;

public final class TestJobStreamsClientImpl
implements TestJobStreamsClient {
    private final TestJobStreamsService service;
    private final AutomationClientImpl client;

    TestJobStreamsClientImpl(AutomationClientImpl client) {
        this.service = (TestJobStreamsService)RestProxy.create(TestJobStreamsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, String jobStreamId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, jobStreamId, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobStreamInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, String jobStreamId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (jobStreamId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobStreamId is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, jobStreamId, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobStreamInner> getAsync(String resourceGroupName, String automationAccountName, String runbookName, String jobStreamId) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName, jobStreamId).flatMap(res -> Mono.justOrEmpty((Object)((JobStreamInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobStreamInner> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, String jobStreamId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName, jobStreamId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobStreamInner get(String resourceGroupName, String automationAccountName, String runbookName, String jobStreamId) {
        return (JobStreamInner)this.getWithResponse(resourceGroupName, automationAccountName, runbookName, jobStreamId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByTestJobSinglePageAsync(String resourceGroupName, String automationAccountName, String runbookName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTestJob(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, filter, "2018-06-30", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByTestJobSinglePageAsync(String resourceGroupName, String automationAccountName, String runbookName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTestJob(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, filter, "2018-06-30", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByTestJobAsync(String resourceGroupName, String automationAccountName, String runbookName, String filter) {
        return new PagedFlux(() -> this.listByTestJobSinglePageAsync(resourceGroupName, automationAccountName, runbookName, filter), nextLink -> this.listByTestJobNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByTestJobAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        String filter = null;
        return new PagedFlux(() -> this.listByTestJobSinglePageAsync(resourceGroupName, automationAccountName, runbookName, filter), nextLink -> this.listByTestJobNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobStreamInner> listByTestJobAsync(String resourceGroupName, String automationAccountName, String runbookName, String filter, Context context) {
        return new PagedFlux(() -> this.listByTestJobSinglePageAsync(resourceGroupName, automationAccountName, runbookName, filter, context), nextLink -> this.listByTestJobNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobStreamInner> listByTestJob(String resourceGroupName, String automationAccountName, String runbookName) {
        String filter = null;
        return new PagedIterable(this.listByTestJobAsync(resourceGroupName, automationAccountName, runbookName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobStreamInner> listByTestJob(String resourceGroupName, String automationAccountName, String runbookName, String filter, Context context) {
        return new PagedIterable(this.listByTestJobAsync(resourceGroupName, automationAccountName, runbookName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByTestJobNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTestJobNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobStreamInner>> listByTestJobNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTestJobNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobStreamListResultInner)res.getValue()).value(), ((JobStreamListResultInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientTest")
    public static interface TestJobStreamsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/streams/{jobStreamId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @PathParam(value="jobStreamId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/streams")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamListResultInner>> listByTestJob(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobStreamListResultInner>> listByTestJobNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

