/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.automation.fluent.TestJobsClient;
import com.azure.resourcemanager.automation.fluent.models.TestJobInner;
import com.azure.resourcemanager.automation.implementation.AutomationClientImpl;
import com.azure.resourcemanager.automation.models.TestJobCreateParameters;
import reactor.core.publisher.Mono;

public final class TestJobsClientImpl
implements TestJobsClient {
    private final TestJobsService service;
    private final AutomationClientImpl client;

    TestJobsClientImpl(AutomationClientImpl client) {
        this.service = (TestJobsService)RestProxy.create(TestJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestJobInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestJobInner>> createWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestJobInner> createAsync(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters) {
        return this.createWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((TestJobInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestJobInner> createWithResponse(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(resourceGroupName, automationAccountName, runbookName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestJobInner create(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters) {
        return (TestJobInner)this.createWithResponse(resourceGroupName, automationAccountName, runbookName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestJobInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestJobInner>> getWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestJobInner> getAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(res -> Mono.justOrEmpty((Object)((TestJobInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestJobInner> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestJobInner get(String resourceGroupName, String automationAccountName, String runbookName) {
        return (TestJobInner)this.getWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resumeWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resumeWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resume(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> resumeAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.resumeWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.resumeWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String resourceGroupName, String automationAccountName, String runbookName) {
        this.resumeWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> stopAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.stopWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.stopWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String resourceGroupName, String automationAccountName, String runbookName) {
        this.stopWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> suspendWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.suspend(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> suspendWithResponseAsync(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (automationAccountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter automationAccountName is required and cannot be null."));
        }
        if (runbookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runbookName is required and cannot be null."));
        }
        String apiVersion = "2018-06-30";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.suspend(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, automationAccountName, runbookName, "2018-06-30", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> suspendAsync(String resourceGroupName, String automationAccountName, String runbookName) {
        return this.suspendWithResponseAsync(resourceGroupName, automationAccountName, runbookName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> suspendWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return (Response)this.suspendWithResponseAsync(resourceGroupName, automationAccountName, runbookName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void suspend(String resourceGroupName, String automationAccountName, String runbookName) {
        this.suspendWithResponse(resourceGroupName, automationAccountName, runbookName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AutomationClientTest")
    public static interface TestJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TestJobInner>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") TestJobCreateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TestJobInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/resume")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> resume(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> stop(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/runbooks/{runbookName}/draft/testJob/suspend")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> suspend(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="automationAccountName") String var4, @PathParam(value="runbookName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

