/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.TestJobsClient;
import com.azure.resourcemanager.automation.fluent.models.TestJobInner;
import com.azure.resourcemanager.automation.implementation.TestJobImpl;
import com.azure.resourcemanager.automation.models.TestJob;
import com.azure.resourcemanager.automation.models.TestJobCreateParameters;
import com.azure.resourcemanager.automation.models.TestJobs;

public final class TestJobsImpl
implements TestJobs {
    private static final ClientLogger LOGGER = new ClientLogger(TestJobsImpl.class);
    private final TestJobsClient innerClient;
    private final AutomationManager serviceManager;

    public TestJobsImpl(TestJobsClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<TestJob> createWithResponse(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters, Context context) {
        Response<TestJobInner> inner = this.serviceClient().createWithResponse(resourceGroupName, automationAccountName, runbookName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TestJobImpl((TestJobInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TestJob create(String resourceGroupName, String automationAccountName, String runbookName, TestJobCreateParameters parameters) {
        TestJobInner inner = this.serviceClient().create(resourceGroupName, automationAccountName, runbookName, parameters);
        if (inner != null) {
            return new TestJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<TestJob> getWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        Response<TestJobInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, runbookName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TestJobImpl((TestJobInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TestJob get(String resourceGroupName, String automationAccountName, String runbookName) {
        TestJobInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, runbookName);
        if (inner != null) {
            return new TestJobImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> resumeWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().resumeWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public void resume(String resourceGroupName, String automationAccountName, String runbookName) {
        this.serviceClient().resume(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public Response<Void> stopWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().stopWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public void stop(String resourceGroupName, String automationAccountName, String runbookName) {
        this.serviceClient().stop(resourceGroupName, automationAccountName, runbookName);
    }

    @Override
    public Response<Void> suspendWithResponse(String resourceGroupName, String automationAccountName, String runbookName, Context context) {
        return this.serviceClient().suspendWithResponse(resourceGroupName, automationAccountName, runbookName, context);
    }

    @Override
    public void suspend(String resourceGroupName, String automationAccountName, String runbookName) {
        this.serviceClient().suspend(resourceGroupName, automationAccountName, runbookName);
    }

    private TestJobsClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

