/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.UsagesClient;
import com.azure.resourcemanager.automation.fluent.models.UsageInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.UsageImpl;
import com.azure.resourcemanager.automation.models.Usage;
import com.azure.resourcemanager.automation.models.Usages;

public final class UsagesImpl
implements Usages {
    private static final ClientLogger LOGGER = new ClientLogger(UsagesImpl.class);
    private final UsagesClient innerClient;
    private final AutomationManager serviceManager;

    public UsagesImpl(UsagesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Usage> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<UsageInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Usage> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<UsageInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageImpl((UsageInner)inner1, this.manager()));
    }

    private UsagesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }
}

