/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.VariableInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Variable;
import com.azure.resourcemanager.automation.models.VariableCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.VariableUpdateParameters;
import java.time.OffsetDateTime;

public final class VariableImpl
implements Variable,
Variable.Definition,
Variable.Update {
    private VariableInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String variableName;
    private VariableCreateOrUpdateParameters createParameters;
    private VariableUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public Boolean isEncrypted() {
        return this.innerModel().isEncrypted();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public VariableInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public VariableImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Variable create() {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Variable create(Context context) {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, this.createParameters, context).getValue());
        return this;
    }

    VariableImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new VariableInner();
        this.serviceManager = serviceManager;
        this.variableName = name;
        this.createParameters = new VariableCreateOrUpdateParameters();
    }

    @Override
    public VariableImpl update() {
        this.updateParameters = new VariableUpdateParameters();
        return this;
    }

    @Override
    public Variable apply() {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Variable apply(Context context) {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, this.updateParameters, context).getValue());
        return this;
    }

    VariableImpl(VariableInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.variableName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "variables");
    }

    @Override
    public Variable refresh() {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().getWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Variable refresh(Context context) {
        this.innerObject = (VariableInner)((Object)this.serviceManager.serviceClient().getVariables().getWithResponse(this.resourceGroupName, this.automationAccountName, this.variableName, context).getValue());
        return this;
    }

    @Override
    public VariableImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public VariableImpl withValue(String value) {
        if (this.isInCreateMode()) {
            this.createParameters.withValue(value);
            return this;
        }
        this.updateParameters.withValue(value);
        return this;
    }

    @Override
    public VariableImpl withDescription(String description) {
        if (this.isInCreateMode()) {
            this.createParameters.withDescription(description);
            return this;
        }
        this.updateParameters.withDescription(description);
        return this;
    }

    @Override
    public VariableImpl withIsEncrypted(Boolean isEncrypted) {
        this.createParameters.withIsEncrypted(isEncrypted);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

