/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.VariablesClient;
import com.azure.resourcemanager.automation.fluent.models.VariableInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.VariableImpl;
import com.azure.resourcemanager.automation.models.Variable;
import com.azure.resourcemanager.automation.models.Variables;

public final class VariablesImpl
implements Variables {
    private static final ClientLogger LOGGER = new ClientLogger(VariablesImpl.class);
    private final VariablesClient innerClient;
    private final AutomationManager serviceManager;

    public VariablesImpl(VariablesClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String variableName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, variableName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String variableName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, variableName);
    }

    @Override
    public Response<Variable> getWithResponse(String resourceGroupName, String automationAccountName, String variableName, Context context) {
        Response<VariableInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, variableName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VariableImpl((VariableInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Variable get(String resourceGroupName, String automationAccountName, String variableName) {
        VariableInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, variableName);
        if (inner != null) {
            return new VariableImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Variable> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<VariableInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VariableImpl((VariableInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Variable> listByAutomationAccount(String resourceGroupName, String automationAccountName, Context context) {
        PagedIterable<VariableInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VariableImpl((VariableInner)((Object)inner1), this.manager()));
    }

    @Override
    public Variable getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String variableName = ResourceManagerUtils.getValueFromIdByName(id, "variables");
        if (variableName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'variables'.", id)));
        }
        return (Variable)this.getWithResponse(resourceGroupName, automationAccountName, variableName, Context.NONE).getValue();
    }

    @Override
    public Response<Variable> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String variableName = ResourceManagerUtils.getValueFromIdByName(id, "variables");
        if (variableName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'variables'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, variableName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String variableName = ResourceManagerUtils.getValueFromIdByName(id, "variables");
        if (variableName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'variables'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, variableName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String variableName = ResourceManagerUtils.getValueFromIdByName(id, "variables");
        if (variableName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'variables'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, variableName, context);
    }

    private VariablesClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public VariableImpl define(String name) {
        return new VariableImpl(name, this.manager());
    }
}

