/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.WatcherInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.Watcher;
import com.azure.resourcemanager.automation.models.WatcherUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class WatcherImpl
implements Watcher,
Watcher.Definition,
Watcher.Update {
    private WatcherInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String watcherName;
    private WatcherUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Long executionFrequencyInSeconds() {
        return this.innerModel().executionFrequencyInSeconds();
    }

    @Override
    public String scriptName() {
        return this.innerModel().scriptName();
    }

    @Override
    public Map<String, String> scriptParameters() {
        Map<String, String> inner = this.innerModel().scriptParameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String scriptRunOn() {
        return this.innerModel().scriptRunOn();
    }

    @Override
    public String status() {
        return this.innerModel().status();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WatcherInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WatcherImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Watcher create() {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Watcher create(Context context) {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, this.innerModel(), context).getValue());
        return this;
    }

    WatcherImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new WatcherInner();
        this.serviceManager = serviceManager;
        this.watcherName = name;
    }

    @Override
    public WatcherImpl update() {
        this.updateParameters = new WatcherUpdateParameters();
        return this;
    }

    @Override
    public Watcher apply() {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Watcher apply(Context context) {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, this.updateParameters, context).getValue());
        return this;
    }

    WatcherImpl(WatcherInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.watcherName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "watchers");
    }

    @Override
    public Watcher refresh() {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().getWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Watcher refresh(Context context) {
        this.innerObject = (WatcherInner)((Object)this.serviceManager.serviceClient().getWatchers().getWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> startWithResponse(Context context) {
        return this.serviceManager.watchers().startWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, context);
    }

    @Override
    public void start() {
        this.serviceManager.watchers().start(this.resourceGroupName, this.automationAccountName, this.watcherName);
    }

    @Override
    public Response<Void> stopWithResponse(Context context) {
        return this.serviceManager.watchers().stopWithResponse(this.resourceGroupName, this.automationAccountName, this.watcherName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.watchers().stop(this.resourceGroupName, this.automationAccountName, this.watcherName);
    }

    @Override
    public WatcherImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WatcherImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WatcherImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public WatcherImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public WatcherImpl withExecutionFrequencyInSeconds(Long executionFrequencyInSeconds) {
        if (this.isInCreateMode()) {
            this.innerModel().withExecutionFrequencyInSeconds(executionFrequencyInSeconds);
            return this;
        }
        this.updateParameters.withExecutionFrequencyInSeconds(executionFrequencyInSeconds);
        return this;
    }

    @Override
    public WatcherImpl withScriptName(String scriptName) {
        this.innerModel().withScriptName(scriptName);
        return this;
    }

    @Override
    public WatcherImpl withScriptParameters(Map<String, String> scriptParameters) {
        this.innerModel().withScriptParameters(scriptParameters);
        return this;
    }

    @Override
    public WatcherImpl withScriptRunOn(String scriptRunOn) {
        this.innerModel().withScriptRunOn(scriptRunOn);
        return this;
    }

    @Override
    public WatcherImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public WatcherImpl withName(String name) {
        this.updateParameters.withName(name);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

