/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.WatchersClient;
import com.azure.resourcemanager.automation.fluent.models.WatcherInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.WatcherImpl;
import com.azure.resourcemanager.automation.models.Watcher;
import com.azure.resourcemanager.automation.models.Watchers;

public final class WatchersImpl
implements Watchers {
    private static final ClientLogger LOGGER = new ClientLogger(WatchersImpl.class);
    private final WatchersClient innerClient;
    private final AutomationManager serviceManager;

    public WatchersImpl(WatchersClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Watcher> getWithResponse(String resourceGroupName, String automationAccountName, String watcherName, Context context) {
        Response<WatcherInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, watcherName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WatcherImpl((WatcherInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Watcher get(String resourceGroupName, String automationAccountName, String watcherName) {
        WatcherInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, watcherName);
        if (inner != null) {
            return new WatcherImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String watcherName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, watcherName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String watcherName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, watcherName);
    }

    @Override
    public Response<Void> startWithResponse(String resourceGroupName, String automationAccountName, String watcherName, Context context) {
        return this.serviceClient().startWithResponse(resourceGroupName, automationAccountName, watcherName, context);
    }

    @Override
    public void start(String resourceGroupName, String automationAccountName, String watcherName) {
        this.serviceClient().start(resourceGroupName, automationAccountName, watcherName);
    }

    @Override
    public Response<Void> stopWithResponse(String resourceGroupName, String automationAccountName, String watcherName, Context context) {
        return this.serviceClient().stopWithResponse(resourceGroupName, automationAccountName, watcherName, context);
    }

    @Override
    public void stop(String resourceGroupName, String automationAccountName, String watcherName) {
        this.serviceClient().stop(resourceGroupName, automationAccountName, watcherName);
    }

    @Override
    public PagedIterable<Watcher> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<WatcherInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WatcherImpl((WatcherInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Watcher> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<WatcherInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WatcherImpl((WatcherInner)((Object)inner1), this.manager()));
    }

    @Override
    public Watcher getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String watcherName = ResourceManagerUtils.getValueFromIdByName(id, "watchers");
        if (watcherName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'watchers'.", id)));
        }
        return (Watcher)this.getWithResponse(resourceGroupName, automationAccountName, watcherName, Context.NONE).getValue();
    }

    @Override
    public Response<Watcher> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String watcherName = ResourceManagerUtils.getValueFromIdByName(id, "watchers");
        if (watcherName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'watchers'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, watcherName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String watcherName = ResourceManagerUtils.getValueFromIdByName(id, "watchers");
        if (watcherName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'watchers'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, watcherName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String watcherName = ResourceManagerUtils.getValueFromIdByName(id, "watchers");
        if (watcherName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'watchers'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, watcherName, context);
    }

    private WatchersClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WatcherImpl define(String name) {
        return new WatcherImpl(name, this.manager());
    }
}

