/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.models.WebhookInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.Webhook;
import com.azure.resourcemanager.automation.models.WebhookCreateOrUpdateParameters;
import com.azure.resourcemanager.automation.models.WebhookUpdateParameters;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class WebhookImpl
implements Webhook,
Webhook.Definition,
Webhook.Update {
    private WebhookInner innerObject;
    private final AutomationManager serviceManager;
    private String resourceGroupName;
    private String automationAccountName;
    private String webhookName;
    private WebhookCreateOrUpdateParameters createParameters;
    private WebhookUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Boolean isEnabled() {
        return this.innerModel().isEnabled();
    }

    @Override
    public String uri() {
        return this.innerModel().uri();
    }

    @Override
    public OffsetDateTime expiryTime() {
        return this.innerModel().expiryTime();
    }

    @Override
    public OffsetDateTime lastInvokedTime() {
        return this.innerModel().lastInvokedTime();
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public RunbookAssociationProperty runbook() {
        return this.innerModel().runbook();
    }

    @Override
    public String runOn() {
        return this.innerModel().runOn();
    }

    @Override
    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    @Override
    public OffsetDateTime lastModifiedTime() {
        return this.innerModel().lastModifiedTime();
    }

    @Override
    public String lastModifiedBy() {
        return this.innerModel().lastModifiedBy();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public WebhookInner innerModel() {
        return this.innerObject;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WebhookImpl withExistingAutomationAccount(String resourceGroupName, String automationAccountName) {
        this.resourceGroupName = resourceGroupName;
        this.automationAccountName = automationAccountName;
        return this;
    }

    @Override
    public Webhook create() {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, this.createParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Webhook create(Context context) {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().createOrUpdateWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, this.createParameters, context).getValue());
        return this;
    }

    WebhookImpl(String name, AutomationManager serviceManager) {
        this.innerObject = new WebhookInner();
        this.serviceManager = serviceManager;
        this.webhookName = name;
        this.createParameters = new WebhookCreateOrUpdateParameters();
    }

    @Override
    public WebhookImpl update() {
        this.updateParameters = new WebhookUpdateParameters();
        return this;
    }

    @Override
    public Webhook apply() {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, this.updateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public Webhook apply(Context context) {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().updateWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, this.updateParameters, context).getValue());
        return this;
    }

    WebhookImpl(WebhookInner innerObject, AutomationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.automationAccountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "automationAccounts");
        this.webhookName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "webhooks");
    }

    @Override
    public Webhook refresh() {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().getWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Webhook refresh(Context context) {
        this.innerObject = (WebhookInner)((Object)this.serviceManager.serviceClient().getWebhooks().getWithResponse(this.resourceGroupName, this.automationAccountName, this.webhookName, context).getValue());
        return this;
    }

    @Override
    public WebhookImpl withName(String name) {
        if (this.isInCreateMode()) {
            this.createParameters.withName(name);
            return this;
        }
        this.updateParameters.withName(name);
        return this;
    }

    @Override
    public WebhookImpl withIsEnabled(Boolean isEnabled) {
        if (this.isInCreateMode()) {
            this.createParameters.withIsEnabled(isEnabled);
            return this;
        }
        this.updateParameters.withIsEnabled(isEnabled);
        return this;
    }

    @Override
    public WebhookImpl withUri(String uri) {
        this.createParameters.withUri(uri);
        return this;
    }

    @Override
    public WebhookImpl withExpiryTime(OffsetDateTime expiryTime) {
        this.createParameters.withExpiryTime(expiryTime);
        return this;
    }

    @Override
    public WebhookImpl withParameters(Map<String, String> parameters) {
        if (this.isInCreateMode()) {
            this.createParameters.withParameters(parameters);
            return this;
        }
        this.updateParameters.withParameters(parameters);
        return this;
    }

    @Override
    public WebhookImpl withRunbook(RunbookAssociationProperty runbook) {
        this.createParameters.withRunbook(runbook);
        return this;
    }

    @Override
    public WebhookImpl withRunOn(String runOn) {
        if (this.isInCreateMode()) {
            this.createParameters.withRunOn(runOn);
            return this;
        }
        this.updateParameters.withRunOn(runOn);
        return this;
    }

    @Override
    public WebhookImpl withDescription(String description) {
        this.updateParameters.withDescription(description);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

