/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.automation.AutomationManager;
import com.azure.resourcemanager.automation.fluent.WebhooksClient;
import com.azure.resourcemanager.automation.fluent.models.WebhookInner;
import com.azure.resourcemanager.automation.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.automation.implementation.WebhookImpl;
import com.azure.resourcemanager.automation.models.Webhook;
import com.azure.resourcemanager.automation.models.Webhooks;

public final class WebhooksImpl
implements Webhooks {
    private static final ClientLogger LOGGER = new ClientLogger(WebhooksImpl.class);
    private final WebhooksClient innerClient;
    private final AutomationManager serviceManager;

    public WebhooksImpl(WebhooksClient innerClient, AutomationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<String> generateUriWithResponse(String resourceGroupName, String automationAccountName, Context context) {
        return this.serviceClient().generateUriWithResponse(resourceGroupName, automationAccountName, context);
    }

    @Override
    public String generateUri(String resourceGroupName, String automationAccountName) {
        return this.serviceClient().generateUri(resourceGroupName, automationAccountName);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String automationAccountName, String webhookName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, automationAccountName, webhookName, context);
    }

    @Override
    public void delete(String resourceGroupName, String automationAccountName, String webhookName) {
        this.serviceClient().delete(resourceGroupName, automationAccountName, webhookName);
    }

    @Override
    public Response<Webhook> getWithResponse(String resourceGroupName, String automationAccountName, String webhookName, Context context) {
        Response<WebhookInner> inner = this.serviceClient().getWithResponse(resourceGroupName, automationAccountName, webhookName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WebhookImpl((WebhookInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Webhook get(String resourceGroupName, String automationAccountName, String webhookName) {
        WebhookInner inner = this.serviceClient().get(resourceGroupName, automationAccountName, webhookName);
        if (inner != null) {
            return new WebhookImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Webhook> listByAutomationAccount(String resourceGroupName, String automationAccountName) {
        PagedIterable<WebhookInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WebhookImpl((WebhookInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Webhook> listByAutomationAccount(String resourceGroupName, String automationAccountName, String filter, Context context) {
        PagedIterable<WebhookInner> inner = this.serviceClient().listByAutomationAccount(resourceGroupName, automationAccountName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WebhookImpl((WebhookInner)((Object)inner1), this.manager()));
    }

    @Override
    public Webhook getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String webhookName = ResourceManagerUtils.getValueFromIdByName(id, "webhooks");
        if (webhookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webhooks'.", id)));
        }
        return (Webhook)this.getWithResponse(resourceGroupName, automationAccountName, webhookName, Context.NONE).getValue();
    }

    @Override
    public Response<Webhook> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String webhookName = ResourceManagerUtils.getValueFromIdByName(id, "webhooks");
        if (webhookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webhooks'.", id)));
        }
        return this.getWithResponse(resourceGroupName, automationAccountName, webhookName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String webhookName = ResourceManagerUtils.getValueFromIdByName(id, "webhooks");
        if (webhookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webhooks'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, automationAccountName, webhookName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String automationAccountName = ResourceManagerUtils.getValueFromIdByName(id, "automationAccounts");
        if (automationAccountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'automationAccounts'.", id)));
        }
        String webhookName = ResourceManagerUtils.getValueFromIdByName(id, "webhooks");
        if (webhookName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'webhooks'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, automationAccountName, webhookName, context);
    }

    private WebhooksClient serviceClient() {
        return this.innerClient;
    }

    private AutomationManager manager() {
        return this.serviceManager;
    }

    @Override
    public WebhookImpl define(String name) {
        return new WebhookImpl(name, this.manager());
    }
}

