/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ActivityInner;
import java.io.IOException;
import java.util.List;

public final class ActivityListResult
implements JsonSerializable<ActivityListResult> {
    private List<ActivityInner> value;
    private String nextLink;

    public List<ActivityInner> value() {
        return this.value;
    }

    public ActivityListResult withValue(List<ActivityInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ActivityListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ActivityListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityListResult)jsonReader.readObject(reader -> {
            ActivityListResult deserializedActivityListResult = new ActivityListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedActivityListResult.value = value = reader.readArray(reader1 -> ActivityInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedActivityListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityListResult;
        });
    }
}

