/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ActivityParameterValidationSet;
import java.io.IOException;
import java.util.List;

public final class ActivityParameter
implements JsonSerializable<ActivityParameter> {
    private String name;
    private String type;
    private Boolean isMandatory;
    private Boolean isDynamic;
    private Long position;
    private Boolean valueFromPipeline;
    private Boolean valueFromPipelineByPropertyName;
    private Boolean valueFromRemainingArguments;
    private String description;
    private List<ActivityParameterValidationSet> validationSet;

    public String name() {
        return this.name;
    }

    public ActivityParameter withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public ActivityParameter withType(String type) {
        this.type = type;
        return this;
    }

    public Boolean isMandatory() {
        return this.isMandatory;
    }

    public ActivityParameter withIsMandatory(Boolean isMandatory) {
        this.isMandatory = isMandatory;
        return this;
    }

    public Boolean isDynamic() {
        return this.isDynamic;
    }

    public ActivityParameter withIsDynamic(Boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    public Long position() {
        return this.position;
    }

    public ActivityParameter withPosition(Long position) {
        this.position = position;
        return this;
    }

    public Boolean valueFromPipeline() {
        return this.valueFromPipeline;
    }

    public ActivityParameter withValueFromPipeline(Boolean valueFromPipeline) {
        this.valueFromPipeline = valueFromPipeline;
        return this;
    }

    public Boolean valueFromPipelineByPropertyName() {
        return this.valueFromPipelineByPropertyName;
    }

    public ActivityParameter withValueFromPipelineByPropertyName(Boolean valueFromPipelineByPropertyName) {
        this.valueFromPipelineByPropertyName = valueFromPipelineByPropertyName;
        return this;
    }

    public Boolean valueFromRemainingArguments() {
        return this.valueFromRemainingArguments;
    }

    public ActivityParameter withValueFromRemainingArguments(Boolean valueFromRemainingArguments) {
        this.valueFromRemainingArguments = valueFromRemainingArguments;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ActivityParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ActivityParameterValidationSet> validationSet() {
        return this.validationSet;
    }

    public ActivityParameter withValidationSet(List<ActivityParameterValidationSet> validationSet) {
        this.validationSet = validationSet;
        return this;
    }

    public void validate() {
        if (this.validationSet() != null) {
            this.validationSet().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeBooleanField("isMandatory", this.isMandatory);
        jsonWriter.writeBooleanField("isDynamic", this.isDynamic);
        jsonWriter.writeNumberField("position", (Number)this.position);
        jsonWriter.writeBooleanField("valueFromPipeline", this.valueFromPipeline);
        jsonWriter.writeBooleanField("valueFromPipelineByPropertyName", this.valueFromPipelineByPropertyName);
        jsonWriter.writeBooleanField("valueFromRemainingArguments", this.valueFromRemainingArguments);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("validationSet", this.validationSet, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ActivityParameter fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityParameter)jsonReader.readObject(reader -> {
            ActivityParameter deserializedActivityParameter = new ActivityParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedActivityParameter.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedActivityParameter.type = reader.getString();
                    continue;
                }
                if ("isMandatory".equals(fieldName)) {
                    deserializedActivityParameter.isMandatory = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDynamic".equals(fieldName)) {
                    deserializedActivityParameter.isDynamic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("position".equals(fieldName)) {
                    deserializedActivityParameter.position = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("valueFromPipeline".equals(fieldName)) {
                    deserializedActivityParameter.valueFromPipeline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("valueFromPipelineByPropertyName".equals(fieldName)) {
                    deserializedActivityParameter.valueFromPipelineByPropertyName = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("valueFromRemainingArguments".equals(fieldName)) {
                    deserializedActivityParameter.valueFromRemainingArguments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedActivityParameter.description = reader.getString();
                    continue;
                }
                if ("validationSet".equals(fieldName)) {
                    List validationSet;
                    deserializedActivityParameter.validationSet = validationSet = reader.readArray(reader1 -> ActivityParameterValidationSet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityParameter;
        });
    }
}

