/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ActivityParameter;
import java.io.IOException;
import java.util.List;

public final class ActivityParameterSet
implements JsonSerializable<ActivityParameterSet> {
    private String name;
    private List<ActivityParameter> parameters;

    public String name() {
        return this.name;
    }

    public ActivityParameterSet withName(String name) {
        this.name = name;
        return this;
    }

    public List<ActivityParameter> parameters() {
        return this.parameters;
    }

    public ActivityParameterSet withParameters(List<ActivityParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ActivityParameterSet fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityParameterSet)jsonReader.readObject(reader -> {
            ActivityParameterSet deserializedActivityParameterSet = new ActivityParameterSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedActivityParameterSet.name = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedActivityParameterSet.parameters = parameters = reader.readArray(reader1 -> ActivityParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityParameterSet;
        });
    }
}

