/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AdvancedScheduleMonthlyOccurrence;
import java.io.IOException;
import java.util.List;

public final class AdvancedSchedule
implements JsonSerializable<AdvancedSchedule> {
    private List<String> weekDays;
    private List<Integer> monthDays;
    private List<AdvancedScheduleMonthlyOccurrence> monthlyOccurrences;

    public List<String> weekDays() {
        return this.weekDays;
    }

    public AdvancedSchedule withWeekDays(List<String> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    public List<Integer> monthDays() {
        return this.monthDays;
    }

    public AdvancedSchedule withMonthDays(List<Integer> monthDays) {
        this.monthDays = monthDays;
        return this;
    }

    public List<AdvancedScheduleMonthlyOccurrence> monthlyOccurrences() {
        return this.monthlyOccurrences;
    }

    public AdvancedSchedule withMonthlyOccurrences(List<AdvancedScheduleMonthlyOccurrence> monthlyOccurrences) {
        this.monthlyOccurrences = monthlyOccurrences;
        return this;
    }

    public void validate() {
        if (this.monthlyOccurrences() != null) {
            this.monthlyOccurrences().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("weekDays", this.weekDays, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("monthDays", this.monthDays, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("monthlyOccurrences", this.monthlyOccurrences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AdvancedSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (AdvancedSchedule)jsonReader.readObject(reader -> {
            AdvancedSchedule deserializedAdvancedSchedule = new AdvancedSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("weekDays".equals(fieldName)) {
                    List weekDays;
                    deserializedAdvancedSchedule.weekDays = weekDays = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("monthDays".equals(fieldName)) {
                    List monthDays;
                    deserializedAdvancedSchedule.monthDays = monthDays = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("monthlyOccurrences".equals(fieldName)) {
                    List monthlyOccurrences;
                    deserializedAdvancedSchedule.monthlyOccurrences = monthlyOccurrences = reader.readArray(reader1 -> AdvancedScheduleMonthlyOccurrence.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAdvancedSchedule;
        });
    }
}

