/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AgentRegistrationKeyName;
import java.io.IOException;

public final class AgentRegistrationRegenerateKeyParameter
implements JsonSerializable<AgentRegistrationRegenerateKeyParameter> {
    private AgentRegistrationKeyName keyName;
    private static final ClientLogger LOGGER = new ClientLogger(AgentRegistrationRegenerateKeyParameter.class);

    public AgentRegistrationKeyName keyName() {
        return this.keyName;
    }

    public AgentRegistrationRegenerateKeyParameter withKeyName(AgentRegistrationKeyName keyName) {
        this.keyName = keyName;
        return this;
    }

    public void validate() {
        if (this.keyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyName in model AgentRegistrationRegenerateKeyParameter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyName", this.keyName == null ? null : this.keyName.toString());
        return jsonWriter.writeEndObject();
    }

    public static AgentRegistrationRegenerateKeyParameter fromJson(JsonReader jsonReader) throws IOException {
        return (AgentRegistrationRegenerateKeyParameter)jsonReader.readObject(reader -> {
            AgentRegistrationRegenerateKeyParameter deserializedAgentRegistrationRegenerateKeyParameter = new AgentRegistrationRegenerateKeyParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyName".equals(fieldName)) {
                    deserializedAgentRegistrationRegenerateKeyParameter.keyName = AgentRegistrationKeyName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAgentRegistrationRegenerateKeyParameter;
        });
    }
}

