/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.AutomationAccountInner;
import com.azure.resourcemanager.automation.models.AutomationAccountState;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Identity;
import com.azure.resourcemanager.automation.models.PrivateEndpointConnection;
import com.azure.resourcemanager.automation.models.Sku;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface AutomationAccount {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public Identity identity();

    public SystemData systemData();

    public Sku sku();

    public String lastModifiedBy();

    public AutomationAccountState state();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public EncryptionProperties encryption();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public Boolean publicNetworkAccess();

    public Boolean disableLocalAuth();

    public String automationHybridServiceUrl();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AutomationAccountInner innerModel();

    public Update update();

    public AutomationAccount refresh();

    public AutomationAccount refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDisableLocalAuth {
            public Update withDisableLocalAuth(Boolean var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(Boolean var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(EncryptionProperties var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithName,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithEncryption,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithDisableLocalAuth {
        public AutomationAccount apply();

        public AutomationAccount apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDisableLocalAuth {
            public WithCreate withDisableLocalAuth(Boolean var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(Boolean var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(EncryptionProperties var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithName,
        WithIdentity,
        WithSku,
        WithEncryption,
        WithPublicNetworkAccess,
        WithDisableLocalAuth {
            public AutomationAccount create();

            public AutomationAccount create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface Blank
        extends WithResourceGroup {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

