/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.AutomationAccountCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.EncryptionProperties;
import com.azure.resourcemanager.automation.models.Identity;
import com.azure.resourcemanager.automation.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class AutomationAccountCreateOrUpdateParameters
implements JsonSerializable<AutomationAccountCreateOrUpdateParameters> {
    private AutomationAccountCreateOrUpdateProperties innerProperties;
    private String name;
    private String location;
    private Identity identity;
    private Map<String, String> tags;

    private AutomationAccountCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public AutomationAccountCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public AutomationAccountCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public AutomationAccountCreateOrUpdateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public AutomationAccountCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public AutomationAccountCreateOrUpdateParameters withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountCreateOrUpdateProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public AutomationAccountCreateOrUpdateParameters withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountCreateOrUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public AutomationAccountCreateOrUpdateParameters withPublicNetworkAccess(Boolean publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountCreateOrUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public AutomationAccountCreateOrUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutomationAccountCreateOrUpdateProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AutomationAccountCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AutomationAccountCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            AutomationAccountCreateOrUpdateParameters deserializedAutomationAccountCreateOrUpdateParameters = new AutomationAccountCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedAutomationAccountCreateOrUpdateParameters.innerProperties = AutomationAccountCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutomationAccountCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAutomationAccountCreateOrUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAutomationAccountCreateOrUpdateParameters.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedAutomationAccountCreateOrUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutomationAccountCreateOrUpdateParameters;
        });
    }
}

