/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.TagSettingsProperties;
import java.io.IOException;
import java.util.List;

public final class AzureQueryProperties
implements JsonSerializable<AzureQueryProperties> {
    private List<String> scope;
    private List<String> locations;
    private TagSettingsProperties tagSettings;

    public List<String> scope() {
        return this.scope;
    }

    public AzureQueryProperties withScope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public AzureQueryProperties withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public TagSettingsProperties tagSettings() {
        return this.tagSettings;
    }

    public AzureQueryProperties withTagSettings(TagSettingsProperties tagSettings) {
        this.tagSettings = tagSettings;
        return this;
    }

    public void validate() {
        if (this.tagSettings() != null) {
            this.tagSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scope", this.scope, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("tagSettings", (JsonSerializable)this.tagSettings);
        return jsonWriter.writeEndObject();
    }

    public static AzureQueryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureQueryProperties)jsonReader.readObject(reader -> {
            AzureQueryProperties deserializedAzureQueryProperties = new AzureQueryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    List scope;
                    deserializedAzureQueryProperties.scope = scope = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedAzureQueryProperties.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tagSettings".equals(fieldName)) {
                    deserializedAzureQueryProperties.tagSettings = TagSettingsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureQueryProperties;
        });
    }
}

