/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.CertificateInner;
import java.time.OffsetDateTime;

public interface Certificate {
    public String id();

    public String name();

    public String type();

    public String thumbprint();

    public OffsetDateTime expiryTime();

    public Boolean isExportable();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public String resourceGroupName();

    public CertificateInner innerModel();

    public Update update();

    public Certificate refresh();

    public Certificate refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithDescription {
        public Certificate apply();

        public Certificate apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIsExportable {
            public WithCreate withIsExportable(Boolean var1);
        }

        public static interface WithThumbprint {
            public WithCreate withThumbprint(String var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithCreate
        extends WithDescription,
        WithThumbprint,
        WithIsExportable {
            public Certificate create();

            public Certificate create(Context var1);
        }

        public static interface WithBase64Value {
            public WithCreate withBase64Value(String var1);
        }

        public static interface WithName {
            public WithBase64Value withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithBase64Value,
    DefinitionStages.WithCreate {
    }
}

