/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.CertificateCreateOrUpdateProperties;
import java.io.IOException;

public final class CertificateCreateOrUpdateParameters
implements JsonSerializable<CertificateCreateOrUpdateParameters> {
    private String name;
    private CertificateCreateOrUpdateProperties innerProperties = new CertificateCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CertificateCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public CertificateCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private CertificateCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String base64Value() {
        return this.innerProperties() == null ? null : this.innerProperties().base64Value();
    }

    public CertificateCreateOrUpdateParameters withBase64Value(String base64Value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withBase64Value(base64Value);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CertificateCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    public CertificateCreateOrUpdateParameters withThumbprint(String thumbprint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withThumbprint(thumbprint);
        return this;
    }

    public Boolean isExportable() {
        return this.innerProperties() == null ? null : this.innerProperties().isExportable();
    }

    public CertificateCreateOrUpdateParameters withIsExportable(Boolean isExportable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateCreateOrUpdateProperties();
        }
        this.innerProperties().withIsExportable(isExportable);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CertificateCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model CertificateCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CertificateCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateParameters deserializedCertificateCreateOrUpdateParameters = new CertificateCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateParameters.innerProperties = CertificateCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCreateOrUpdateParameters;
        });
    }
}

