/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.CertificateUpdateProperties;
import java.io.IOException;

public final class CertificateUpdateParameters
implements JsonSerializable<CertificateUpdateParameters> {
    private String name;
    private CertificateUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public CertificateUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private CertificateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CertificateUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CertificateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateUpdateParameters)jsonReader.readObject(reader -> {
            CertificateUpdateParameters deserializedCertificateUpdateParameters = new CertificateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCertificateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCertificateUpdateParameters.innerProperties = CertificateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateUpdateParameters;
        });
    }
}

