/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.ConnectionInner;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Connection {
    public String id();

    public String name();

    public String type();

    public ConnectionTypeAssociationProperty connectionType();

    public Map<String, String> fieldDefinitionValues();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public String resourceGroupName();

    public ConnectionInner innerModel();

    public Update update();

    public Connection refresh();

    public Connection refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithFieldDefinitionValues {
            public Update withFieldDefinitionValues(Map<String, String> var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithDescription,
    UpdateStages.WithFieldDefinitionValues {
        public Connection apply();

        public Connection apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithFieldDefinitionValues {
            public WithCreate withFieldDefinitionValues(Map<String, String> var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithCreate
        extends WithDescription,
        WithFieldDefinitionValues {
            public Connection create();

            public Connection create(Context var1);
        }

        public static interface WithConnectionType {
            public WithCreate withConnectionType(ConnectionTypeAssociationProperty var1);
        }

        public static interface WithName {
            public WithConnectionType withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithConnectionType,
    DefinitionStages.WithCreate {
    }
}

