/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.ConnectionTypeAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class ConnectionCreateOrUpdateParameters
implements JsonSerializable<ConnectionCreateOrUpdateParameters> {
    private String name;
    private ConnectionCreateOrUpdateProperties innerProperties = new ConnectionCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public ConnectionCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private ConnectionCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ConnectionCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public ConnectionTypeAssociationProperty connectionType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionType();
    }

    public ConnectionCreateOrUpdateParameters withConnectionType(ConnectionTypeAssociationProperty connectionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionCreateOrUpdateProperties();
        }
        this.innerProperties().withConnectionType(connectionType);
        return this;
    }

    public Map<String, String> fieldDefinitionValues() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldDefinitionValues();
    }

    public ConnectionCreateOrUpdateParameters withFieldDefinitionValues(Map<String, String> fieldDefinitionValues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionCreateOrUpdateProperties();
        }
        this.innerProperties().withFieldDefinitionValues(fieldDefinitionValues);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectionCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ConnectionCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            ConnectionCreateOrUpdateParameters deserializedConnectionCreateOrUpdateParameters = new ConnectionCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionCreateOrUpdateParameters.innerProperties = ConnectionCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionCreateOrUpdateParameters;
        });
    }
}

