/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionInner;
import java.io.IOException;
import java.util.List;

public final class ConnectionListResult
implements JsonSerializable<ConnectionListResult> {
    private List<ConnectionInner> value;
    private String nextLink;

    public List<ConnectionInner> value() {
        return this.value;
    }

    public ConnectionListResult withValue(List<ConnectionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ConnectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionListResult)jsonReader.readObject(reader -> {
            ConnectionListResult deserializedConnectionListResult = new ConnectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConnectionListResult.value = value = reader.readArray(reader1 -> ConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConnectionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionListResult;
        });
    }
}

