/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeInner;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.time.OffsetDateTime;
import java.util.Map;

public interface ConnectionType {
    public String id();

    public String name();

    public String type();

    public Boolean isGlobal();

    public Map<String, FieldDefinition> fieldDefinitions();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public String resourceGroupName();

    public ConnectionTypeInner innerModel();

    public Update update();

    public ConnectionType refresh();

    public ConnectionType refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithFieldDefinitions {
            public Update withFieldDefinitions(Map<String, FieldDefinition> var1);
        }

        public static interface WithIsGlobal {
            public Update withIsGlobal(Boolean var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithIsGlobal,
    UpdateStages.WithFieldDefinitions {
        public ConnectionType apply();

        public ConnectionType apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIsGlobal {
            public WithCreate withIsGlobal(Boolean var1);
        }

        public static interface WithCreate
        extends WithIsGlobal {
            public ConnectionType create();

            public ConnectionType create(Context var1);
        }

        public static interface WithFieldDefinitions {
            public WithCreate withFieldDefinitions(Map<String, FieldDefinition> var1);
        }

        public static interface WithName {
            public WithFieldDefinitions withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithFieldDefinitions,
    DefinitionStages.WithCreate {
    }
}

