/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.FieldDefinition;
import java.io.IOException;
import java.util.Map;

public final class ConnectionTypeCreateOrUpdateParameters
implements JsonSerializable<ConnectionTypeCreateOrUpdateParameters> {
    private String name;
    private ConnectionTypeCreateOrUpdateProperties innerProperties = new ConnectionTypeCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionTypeCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public ConnectionTypeCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private ConnectionTypeCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean isGlobal() {
        return this.innerProperties() == null ? null : this.innerProperties().isGlobal();
    }

    public ConnectionTypeCreateOrUpdateParameters withIsGlobal(Boolean isGlobal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionTypeCreateOrUpdateProperties();
        }
        this.innerProperties().withIsGlobal(isGlobal);
        return this;
    }

    public Map<String, FieldDefinition> fieldDefinitions() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldDefinitions();
    }

    public ConnectionTypeCreateOrUpdateParameters withFieldDefinitions(Map<String, FieldDefinition> fieldDefinitions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionTypeCreateOrUpdateProperties();
        }
        this.innerProperties().withFieldDefinitions(fieldDefinitions);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectionTypeCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ConnectionTypeCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionTypeCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionTypeCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            ConnectionTypeCreateOrUpdateParameters deserializedConnectionTypeCreateOrUpdateParameters = new ConnectionTypeCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionTypeCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionTypeCreateOrUpdateParameters.innerProperties = ConnectionTypeCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionTypeCreateOrUpdateParameters;
        });
    }
}

