/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionTypeInner;
import java.io.IOException;
import java.util.List;

public final class ConnectionTypeListResult
implements JsonSerializable<ConnectionTypeListResult> {
    private List<ConnectionTypeInner> value;
    private String nextLink;

    public List<ConnectionTypeInner> value() {
        return this.value;
    }

    public ConnectionTypeListResult withValue(List<ConnectionTypeInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ConnectionTypeListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionTypeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionTypeListResult)jsonReader.readObject(reader -> {
            ConnectionTypeListResult deserializedConnectionTypeListResult = new ConnectionTypeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConnectionTypeListResult.value = value = reader.readArray(reader1 -> ConnectionTypeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConnectionTypeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionTypeListResult;
        });
    }
}

