/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ConnectionUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class ConnectionUpdateParameters
implements JsonSerializable<ConnectionUpdateParameters> {
    private String name;
    private ConnectionUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public ConnectionUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private ConnectionUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ConnectionUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Map<String, String> fieldDefinitionValues() {
        return this.innerProperties() == null ? null : this.innerProperties().fieldDefinitionValues();
    }

    public ConnectionUpdateParameters withFieldDefinitionValues(Map<String, String> fieldDefinitionValues) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectionUpdateProperties();
        }
        this.innerProperties().withFieldDefinitionValues(fieldDefinitionValues);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionUpdateParameters)jsonReader.readObject(reader -> {
            ConnectionUpdateParameters deserializedConnectionUpdateParameters = new ConnectionUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnectionUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConnectionUpdateParameters.innerProperties = ConnectionUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionUpdateParameters;
        });
    }
}

