/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentHash;
import java.io.IOException;

public final class ContentLink
implements JsonSerializable<ContentLink> {
    private String uri;
    private ContentHash contentHash;
    private String version;

    public String uri() {
        return this.uri;
    }

    public ContentLink withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public ContentHash contentHash() {
        return this.contentHash;
    }

    public ContentLink withContentHash(ContentHash contentHash) {
        this.contentHash = contentHash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContentLink withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.contentHash() != null) {
            this.contentHash().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeJsonField("contentHash", (JsonSerializable)this.contentHash);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static ContentLink fromJson(JsonReader jsonReader) throws IOException {
        return (ContentLink)jsonReader.readObject(reader -> {
            ContentLink deserializedContentLink = new ContentLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    deserializedContentLink.uri = reader.getString();
                    continue;
                }
                if ("contentHash".equals(fieldName)) {
                    deserializedContentLink.contentHash = ContentHash.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedContentLink.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContentLink;
        });
    }
}

